CREATE TABLE W83B.W83B01T00 (
       OIDW83B01            INTEGER NOT NULL,
       NOMW83B01            VARCHAR2(50) NOT NULL,
       DNIW83B01            VARCHAR2(10) NOT NULL,
       ORGW83B01            VARCHAR2(50) NOT NULL,
       EMAW83B01            VARCHAR2(50) NULL,
       DELW83B01            NUMBER(1) NOT NULL,
       FECW83B01            DATE NULL,
       FEDW83B01            DATE NULL,
       TERW83B01       		NUMBER(2) NOT NULL,
       TELW83B01            NUMBER(9) NULL,
       CONSTRAINT PK_W83B01T00 PRIMARY KEY(OIDW83B01) USING INDEX TABLESPACE W8302E00
);

COMMENT ON TABLE W83B.W83B01T00 IS 'USUARIOS';
COMMENT ON COLUMN W83B.W83B01T00.OIDW83B01 IS 'OID USUARIO';
COMMENT ON COLUMN W83B.W83B01T00.NOMW83B01 IS 'NOMBRE DE USUARIO';
COMMENT ON COLUMN W83B.W83B01T00.DNIW83B01 IS 'DNI DE USUARIO';
COMMENT ON COLUMN W83B.W83B01T00.ORGW83B01 IS 'ORGANIZACIN';
COMMENT ON COLUMN W83B.W83B01T00.EMAW83B01 IS 'E-MAIL';
COMMENT ON COLUMN W83B.W83B01T00.DELW83B01 IS 'USUARIO BORRADO';
COMMENT ON COLUMN W83B.W83B01T00.FECW83B01 IS 'FECHA ALTA';
COMMENT ON COLUMN W83B.W83B01T00.FEDW83B01 IS 'FECHA BAJA';
COMMENT ON COLUMN W83B.W83B01T00.TERW83B01 IS 'TERRITORIO';
COMMENT ON COLUMN W83B.W83B01T00.TELW83B01 IS 'TELEFONO';


CREATE TABLE W83B.W83B02T00 (
       OIDW83B02              INTEGER NOT NULL,
       CASW83B02              VARCHAR2(20) NOT NULL,
       EUSW83B02              VARCHAR2(20) NOT NULL,
       CONSTRAINT PK_W83B02T00 PRIMARY KEY(OIDW83B02) USING INDEX TABLESPACE W8302E00
);
COMMENT ON TABLE W83B.W83B02T00 IS 'ROLES';
COMMENT ON COLUMN W83B.W83B02T00.OIDW83B02 IS 'OID DE ROL';
COMMENT ON COLUMN W83B.W83B02T00.CASW83B02 IS 'NOMBRE EN CASTELLANO';
COMMENT ON COLUMN W83B.W83B02T00.EUSW83B02 IS 'NOMBRE EN EUSKERA';


CREATE TABLE W83B.W83B03T00 (
       OIDW83B01              INTEGER NOT NULL,
       OIDW83B02              INTEGER NOT NULL,
       FECW83B03              DATE NULL,
       CONSTRAINT PK_W83B03T00 PRIMARY KEY(OIDW83B01,OIDW83B02) USING INDEX TABLESPACE W8302E00,
       CONSTRAINT FK_W83B03T00_00 FOREIGN KEY(OIDW83B01)
       		REFERENCES W83B.W83B01T00(OIDW83B01),
       CONSTRAINT FK_W83B03T00_01 FOREIGN KEY(OIDW83B02)
       		REFERENCES W83B.W83B02T00(OIDW83B02)
);
COMMENT ON TABLE W83B.W83B03T00 IS 'USUARIOS-ROLES';
COMMENT ON COLUMN W83B.W83B03T00.OIDW83B01 IS 'OID DE USUARIO';
COMMENT ON COLUMN W83B.W83B03T00.OIDW83B02 IS 'OID DE ROL';
COMMENT ON COLUMN W83B.W83B03T00.FECW83B03 IS 'FECHA';

CREATE TABLE W83B.W83B04T00 (
       OIDW83B02        INTEGER NOT NULL,
       TOTW83B04       NUMBER(1) NULL,
       ADMW83B04       NUMBER(1) NULL,
       DELW83B04        NUMBER(1) NULL,
       REDW83B04        NUMBER(1) NULL,
       WRTW83B04       NUMBER(1) NULL,
       CREW83B04        NUMBER(1) NULL,
       CONSTRAINT PK_W83B04T00 PRIMARY KEY(OIDW83B02) USING INDEX TABLESPACE W8302E00
);

COMMENT ON TABLE W83B.W83B04T00 IS 'PERMISOS POR ROL';
COMMENT ON COLUMN W83B.W83B04T00.OIDW83B02 IS 'OID DE ROL';
COMMENT ON COLUMN W83B.W83B04T00.TOTW83B04 IS 'CONTROL TOTAL';
COMMENT ON COLUMN W83B.W83B04T00.ADMW83B04 IS 'ADMINISTRACIN';
COMMENT ON COLUMN W83B.W83B04T00.DELW83B04 IS 'BORRADO';
COMMENT ON COLUMN W83B.W83B04T00.REDW83B04 IS 'LECTURA';
COMMENT ON COLUMN W83B.W83B04T00.WRTW83B04 IS 'ESCRITURA';
COMMENT ON COLUMN W83B.W83B04T00.CREW83B04 IS 'CREAR';

CREATE TABLE W83B.W83B06T00 (
       OIDW83B06            INTEGER NOT NULL,
       CASW83B06            VARCHAR2(30) NOT NULL,
       EUSW83B06            VARCHAR2(30) NOT NULL,
       CONSTRAINT PK_W83B06T00 PRIMARY KEY(OIDW83B06) USING INDEX TABLESPACE W8302E00
);

COMMENT ON TABLE W83B.W83B06T00 IS 'EVENTOS DEFINIDOS';
COMMENT ON COLUMN W83B.W83B06T00.OIDW83B06 IS 'OID DE EVENTO';
COMMENT ON COLUMN W83B.W83B06T00. CASW83B06 IS 'NOMBRE EN CASTELLANO';
COMMENT ON COLUMN W83B.W83B06T00. EUSW83B06 IS 'NOMBRE EN EUSKERA';


CREATE TABLE W83B.W83B07T00 (
       OIDW83B07              INTEGER NOT NULL,
       OIDW83B01              INTEGER NOT NULL,
	   DOIW83B07		      VARCHAR2(17) NULL,
	   DOVW83B07		      VARCHAR2(17) NULL,
       FIRW83B07              NUMBER(1) NULL,
       FECW83B07              DATE NOT NULL,
       BDOW83B07              BLOB NULL,
       TLPW83B07              NUMBER(2) NOT NULL,
       SINW83B07              NUMBER(3) NOT NULL,
       CFIW83B07              NUMBER(3) NOT NULL,
       FCRW83B07              DATE NULL,
       NUPW83B07              NUMBER(3) NOT NULL,
       TCAW83B07              NUMBER(9) NOT NULL,
       TNTW83B07              NUMBER(9) NOT NULL,
       EXPW83B07			  NUMBER(1) NOT NULL,
       FBLW83B07              BLOB NULL,
       BDVW83B07              BLOB NULL,
       FBVW83B07              BLOB NULL,
       NDFW83B07              VARCHAR2(29) NOT NULL,
       CONSTRAINT PK_W83B07T00 PRIMARY KEY(OIDW83B07) USING INDEX TABLESPACE W8302E00,
       CONSTRAINT FK_W83B07T00_00 FOREIGN KEY(OIDW83B01)
       		REFERENCES W83B.W83B01T00(OIDW83B01)
)
LOB (BDOW83B07) STORE AS W83B01SL00 ( TABLESPACE W8301E00 DISABLE STORAGE IN ROW NOCACHE LOGGING ) ,
LOB (FBLW83B07) STORE AS W83B02SL00 ( TABLESPACE W8301E00 DISABLE STORAGE IN ROW NOCACHE LOGGING ) ,
LOB (BDVW83B07) STORE AS W83B03SL00 ( TABLESPACE W8301E00 DISABLE STORAGE IN ROW NOCACHE LOGGING ) ,
LOB (FBVW83B07) STORE AS W83B04SL00 ( TABLESPACE W8301E00 DISABLE STORAGE IN ROW NOCACHE LOGGING ) TABLESPACE W8301E00;


COMMENT ON TABLE W83B.W83B07T00 IS 'PREAVISOS';
COMMENT ON COLUMN W83B.W83B07T00.OIDW83B07 IS 'OID DE PREAVISO';
COMMENT ON COLUMN W83B.W83B07T00.OIDW83B01 IS 'OID DE USUARIO';
COMMENT ON COLUMN W83B.W83B07T00.DOIW83B07 IS 'OID DOKUSI IDA';
COMMENT ON COLUMN W83B.W83B07T00.DOVW83B07 IS 'OID DOKUSI VUELTA';
COMMENT ON COLUMN W83B.W83B07T00.FIRW83B07 IS 'FIRMADO';
COMMENT ON COLUMN W83B.W83B07T00.FECW83B07 IS 'FECHA ALTA';
COMMENT ON COLUMN W83B.W83B07T00.BDOW83B07 IS 'DOCUMENTO TEXTO PLANO';
COMMENT ON COLUMN W83B.W83B07T00.TLPW83B07 IS 'TERRITORIO LOTE PREAVISOS';
COMMENT ON COLUMN W83B.W83B07T00.SINW83B07 IS 'SINDICATO';
COMMENT ON COLUMN W83B.W83B07T00.CFIW83B07 IS 'CORRELATIVO FICHERO';
COMMENT ON COLUMN W83B.W83B07T00.FCRW83B07 IS 'FECHA CREACION';
COMMENT ON COLUMN W83B.W83B07T00.NUPW83B07 IS 'NUMERO PREAVISOS';
COMMENT ON COLUMN W83B.W83B07T00.TCAW83B07 IS 'TOTAL CENTROS AFECTADOS';
COMMENT ON COLUMN W83B.W83B07T00.TNTW83B07 IS 'TOTAL NUMERO TRABAJADORES';
COMMENT ON COLUMN W83B.W83B07T00.EXPW83B07 IS 'EXPEDIENTE';
COMMENT ON COLUMN W83B.W83B07T00.FBLW83B07 IS 'FIRMA';
COMMENT ON COLUMN W83B.W83B07T00.BDVW83B07 IS 'DOCUMENTO VALIDADO';
COMMENT ON COLUMN W83B.W83B07T00.FBVW83B07 IS 'FIRMA VALIDADO';
COMMENT ON COLUMN W83B.W83B07T00.NDFW83B07 IS 'NOMBRE FISICO DEL FICHERO';



CREATE TABLE W83B.W83B08T00 (
       OIDW83B08            INTEGER NOT NULL,
       OIDW83B07            INTEGER NOT NULL,
       FECW83B08            DATE NOT NULL,
       IDTW83B08            NUMBER (1) NOT NULL,
       IDRW83B08       	    VARCHAR (15) NOT NULL,
       CONSTRAINT PK_W83B08T00 PRIMARY KEY(OIDW83B08) USING INDEX TABLESPACE W8302E00,
       CONSTRAINT FK_W83B07T00_01 FOREIGN KEY(OIDW83B07)
                REFERENCES W83B.W83B07T00(OIDW83B07)
);

COMMENT ON TABLE W83B.W83B08T00 IS 'LIBRO DE REGISTRO';
COMMENT ON COLUMN W83B.W83B08T00.OIDW83B08 IS 'OID LIBRO DE REGISTRO';
COMMENT ON COLUMN W83B.W83B08T00.OIDW83B07 IS 'OID DE PREAVISO';
COMMENT ON COLUMN W83B.W83B08T00.IDTW83B08 IS 'TIPO DE REGISTRO';
COMMENT ON COLUMN W83B.W83B08T00.FECW83B08 IS 'FECHA DE ENTRADA EN EL REGISTRO';
COMMENT ON COLUMN W83B.W83B08T00.IDRW83B08 IS 'IDENTIFICADOR DE ENTRADA EN EL LIBRO DE REGISTRO';


CREATE TABLE W83B.W83B09T00 (
       OIDW83B09              INTEGER NOT NULL,
       ACCW83B09              VARCHAR(50) NOT NULL,
       ACEW83B09              VARCHAR(50) NOT NULL,
       CONSTRAINT PK_W83B09T00 PRIMARY KEY(OIDW83B09) USING INDEX TABLESPACE W8302E00
       );

COMMENT ON TABLE W83B.W83B09T00 IS 'TIPO DE ACCIN';
COMMENT ON COLUMN W83B.W83B09T00.OIDW83B09 IS 'OID TIPO DE ACCIN';
COMMENT ON COLUMN W83B.W83B09T00.ACCW83B09 IS 'ACCIN EN CASTELLANO';
COMMENT ON COLUMN W83B.W83B09T00.ACEW83B09 IS 'ACCIN EN EUSKERA';


CREATE TABLE W83B.W83B05T00 (
       OIDW83B05        INTEGER NOT NULL,
       OIDW83B06        INTEGER NOT NULL,
       OIDW83B01        INTEGER NOT NULL,
       OIDW83B07        INTEGER NOT NULL,
       OIDW83B09        INTEGER NOT NULL,
       FECW83B05        DATE NOT NULL,
       CONSTRAINT PK_W83B05T00 PRIMARY KEY(OIDW83B05) USING INDEX TABLESPACE W8302E00,
       CONSTRAINT FK_W83B05T00_00 FOREIGN KEY(OIDW83B01)
       		REFERENCES W83B.W83B01T00(OIDW83B01),
       CONSTRAINT FK_W83B05T00_03 FOREIGN KEY(OIDW83B09)
                REFERENCES W83B.W83B09T00(OIDW83B09),
       CONSTRAINT FK_W83B05T00_02 FOREIGN KEY(OIDW83B07)
                REFERENCES W83B.W83B07T00(OIDW83B07),
       CONSTRAINT FK_W83B05T00_01 FOREIGN KEY(OIDW83B06)
                REFERENCES W83B.W83B06T00(OIDW83B06)
);


COMMENT ON TABLE W83B.W83B05T00 IS 'REGISTRO DE ACCIONES';
COMMENT ON COLUMN W83B.W83B05T00.OIDW83B05 IS 'IDENTIFICADOR CORRELATIVO';
COMMENT ON COLUMN W83B.W83B05T00.OIDW83B06 IS 'OID DE EVENTO';
COMMENT ON COLUMN W83B.W83B05T00.OIDW83B01 IS 'OID DE USUARIO';
COMMENT ON COLUMN W83B.W83B05T00.OIDW83B07 IS 'OID DE PREAVISO';
COMMENT ON COLUMN W83B.W83B05T00.OIDW83B09 IS 'OID DE TIPO DE ACCIN';
COMMENT ON COLUMN W83B.W83B05T00.FECW83B05 IS 'FECHA';



CREATE TABLE W83B.W83B10T00  (
       CODW83B10         VARCHAR2(10) NOT NULL,
       TIPW83B10         VARCHAR2(2) NULL,
       RSOW83B10         VARCHAR2(50) NULL,
       CCIW83B10         VARCHAR2(9) NULL,
       PSSW83B10         VARCHAR2(2) NULL,
       NROW83B10         VARCHAR2(7) NULL,
       DIGW83B10         VARCHAR2(2) NULL,
       DOMW83B10         VARCHAR2(50) NULL,
       PRVW83B10         NUMBER(2) NULL,
       MUNW83B10         NUMBER(3) NULL,
       CPOW83B10         VARCHAR2(5) NULL,
       TLFW83B10         VARCHAR2(15) NULL,
       FAXW83B10         VARCHAR2(15) NULL,
       EMAW83B10         VARCHAR2(50) NULL,
       CNAW83B10         VARCHAR2(4) NULL,
       FINW83B10         DATE NULL,
       FREW83B10         DATE NULL,
       NREW83B10         VARCHAR2(15) NULL,
       SPAW83B10         VARCHAR2(1) NULL,
       GLOW83B10         VARCHAR2(1) NULL,
       NCEW83B10         NUMBER(6) NULL,
       NTRW83B10         NUMBER(6) NULL,
       ADMW83B10         VARCHAR2(1) NULL,
       OIDW83B10         NUMBER(13) NULL,
       CSIW83B10         VARCHAR2(3) NULL,
       NOPW83B10         NUMBER(3) NULL,
       NDFW83B10         VARCHAR2(29) NULL,
       PRTW83B10         NUMBER(1) DEFAULT 0,
       CONSTRAINT PK_W83B10T00 PRIMARY KEY(NOPW83B10,NDFW83B10) USING INDEX TABLESPACE W8302E00);

COMMENT ON TABLE W83B.W83B10T00 IS 'TABLA DE ENTRADA PARA LA APLICACION D16';
COMMENT ON COLUMN W83B.W83B10T00.CODW83B10 IS 'USUARIO QUE LANZA EL PROCESO QUE CREA EL REGISTRO';
COMMENT ON COLUMN W83B.W83B10T00.TIPW83B10 IS 'TIPO DE DOCUMENTO 1 - PREAVISO 2- IMPUGNACION';
COMMENT ON COLUMN W83B.W83B10T00.RSOW83B10 IS 'RAZON SOCIAL DE LA EMPRESA';
COMMENT ON COLUMN W83B.W83B10T00.CCIW83B10 IS 'CIF/NIF EMPRESA';
COMMENT ON COLUMN W83B.W83B10T00.PSSW83B10 IS 'PROVINCIA DEL NUMERO DE LA SS';
COMMENT ON COLUMN W83B.W83B10T00.NROW83B10 IS 'NUMERO SS';
COMMENT ON COLUMN W83B.W83B10T00.DIGW83B10 IS 'DIGITO DE CONTROL DEL NUMERO DE SS';
COMMENT ON COLUMN W83B.W83B10T00.DOMW83B10 IS 'DOMICILIO DE LA EMPRESA';
COMMENT ON COLUMN W83B.W83B10T00.PRVW83B10 IS 'PROVINCIA DE LA EMPRESA';
COMMENT ON COLUMN W83B.W83B10T00.MUNW83B10 IS 'MUNICIPIO DE LA EMPRESA';
COMMENT ON COLUMN W83B.W83B10T00.CPOW83B10 IS 'CODIGO POSTAL DE LA EMPRESA';
COMMENT ON COLUMN W83B.W83B10T00.TLFW83B10 IS 'NUMERO DE TELEFONO';
COMMENT ON COLUMN W83B.W83B10T00.FAXW83B10 IS 'FAX';
COMMENT ON COLUMN W83B.W83B10T00.EMAW83B10 IS 'EMAIL';
COMMENT ON COLUMN W83B.W83B10T00.CNAW83B10 IS 'CNAE';
COMMENT ON COLUMN W83B.W83B10T00.FINW83B10 IS 'FECHA DE INICIO';
COMMENT ON COLUMN W83B.W83B10T00.FREW83B10 IS 'FECHA DE REGISTRO';
COMMENT ON COLUMN W83B.W83B10T00.NREW83B10 IS 'NUMERO DE REGISTRO';
COMMENT ON COLUMN W83B.W83B10T00.SPAW83B10 IS 'ELECION PARCIAL';
COMMENT ON COLUMN W83B.W83B10T00.GLOW83B10 IS 'PREAVISO GLOBAL';
COMMENT ON COLUMN W83B.W83B10T00.NCEW83B10 IS 'NUMERO DE CENTROS AFECTADOS';
COMMENT ON COLUMN W83B.W83B10T00.NTRW83B10 IS 'NUMERO DE TRABAJADORES';
COMMENT ON COLUMN W83B.W83B10T00.ADMW83B10 IS 'ADMINISTRACION/EMPRESA';
COMMENT ON COLUMN W83B.W83B10T00.OIDW83B10 IS 'IDENTIFICACION DEL DOCUMENTO';
COMMENT ON COLUMN W83B.W83B10T00.CSIW83B10 IS 'CODIGO DEL SINDICATO';
COMMENT ON COLUMN W83B.W83B10T00.NOPW83B10 IS 'NUMERO DE PREAVISO';
COMMENT ON COLUMN W83B.W83B10T00.NDFW83B10 IS 'NOMBRE FICHERO PREAVISO';
COMMENT ON COLUMN W83B.W83B10T00.PRTW83B10 IS 'PREAVISO TRATADO 0- no tratado 1- tratado';
COMMENT ON COLUMN W83B.W83B10T00.OIDW83B07 IS 'OID DE PREAVISO';
COMMIT;